/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jade.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.ui.IBorderStyle;
import mcp.mobius.waila.api.ui.IElement;
import mcp.mobius.waila.api.ui.IElementHelper;
import mcp.mobius.waila.api.ui.IProgressStyle;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import reliquary.blocks.ApothecaryCauldronBlock;
import reliquary.blocks.tile.ApothecaryCauldronBlockEntity;
import reliquary.compat.jade.provider.CachedBodyDataProvider;
import reliquary.compat.jade.provider.JadeHelper;
import reliquary.util.potions.XRPotionHelper;
import snownee.jade.VanillaPlugin;

public class DataProviderCauldron
extends CachedBodyDataProvider {
    @Override
    public List<List<IElement>> getWailaBodyToCache(IElementHelper helper, BlockAccessor accessor, IPluginConfig config) {
        ItemStack stack;
        BlockEntity blockEntity;
        ArrayList<List<IElement>> lines = new ArrayList<List<IElement>>();
        if (!(accessor.getBlock() instanceof ApothecaryCauldronBlock) || !((blockEntity = accessor.getBlockEntity()) instanceof ApothecaryCauldronBlockEntity)) {
            return List.of();
        }
        ApothecaryCauldronBlockEntity cauldron = (ApothecaryCauldronBlockEntity)blockEntity;
        if (cauldron.getEffects().isEmpty()) {
            return List.of();
        }
        ArrayList<IElement> ingredientHints = new ArrayList<IElement>();
        if (!cauldron.hasNetherwart()) {
            ingredientHints.add(helper.item(Items.f_42588_.m_7968_(), JadeHelper.ITEM_ICON_SCALE, JadeHelper.MISSING));
        } else {
            ingredientHints.add(helper.item(Items.f_42588_.m_7968_(), JadeHelper.ITEM_ICON_SCALE, JadeHelper.SATISFIED));
        }
        if (cauldron.hasDragonBreath()) {
            if (!cauldron.hasGunpowder()) {
                ingredientHints.add(helper.item(Items.f_42403_.m_7968_(), JadeHelper.ITEM_ICON_SCALE, JadeHelper.MISSING));
            } else {
                ingredientHints.add(helper.item(Items.f_42403_.m_7968_(), JadeHelper.ITEM_ICON_SCALE, JadeHelper.SATISFIED));
            }
            ingredientHints.add(helper.item(Items.f_42735_.m_7968_(), JadeHelper.ITEM_ICON_SCALE, JadeHelper.SATISFIED));
        }
        lines.add(ingredientHints);
        ArrayList<IElement> ingredients1 = new ArrayList<IElement>();
        if (cauldron.getRedstoneCount() > 0) {
            stack = new ItemStack((ItemLike)Items.f_42451_, cauldron.getRedstoneCount());
            ingredients1.add(helper.item(stack));
        }
        if (cauldron.getGlowstoneCount() > 0) {
            stack = new ItemStack((ItemLike)Items.f_42525_, cauldron.getGlowstoneCount());
            ingredients1.add(helper.item(stack));
        }
        lines.add(ingredients1);
        FluidStack fluidPlaceHolder = new FluidStack((Fluid)Fluids.f_76193_, 1000 * cauldron.getLiquidLevel() / 3);
        TranslatableComponent potionType = cauldron.hasDragonBreath() ? new TranslatableComponent("waila.reliquary.cauldron.lingering") : (cauldron.hasGunpowder() ? new TranslatableComponent("waila.reliquary.cauldron.splash") : new TranslatableComponent("waila.reliquary.cauldron.potion"));
        lines.add(DataProviderCauldron.createTank(helper, fluidPlaceHolder, 1000, (Component)potionType));
        ArrayList<Component> components = new ArrayList<Component>();
        XRPotionHelper.addPotionTooltip(cauldron.getEffects(), components);
        lines.add(components.stream().map(arg_0 -> ((IElementHelper)helper).text(arg_0)).collect(Collectors.toList()));
        return lines;
    }

    public static List<IElement> createTank(IElementHelper helper, FluidStack fluidStack, int capacity, Component displayName) {
        TranslatableComponent text;
        if (displayName == Component.f_130760_) {
            displayName = fluidStack.getDisplayName();
        }
        if (capacity <= 0) {
            return List.of();
        }
        if (fluidStack.isEmpty()) {
            text = new TranslatableComponent("jade.fluid.empty");
        } else {
            String amountText = VanillaPlugin.getDisplayHelper().humanReadableNumber((double)fluidStack.getAmount(), "B", true);
            text = new TranslatableComponent("jade.fluid", new Object[]{displayName, amountText});
        }
        IProgressStyle progressStyle = helper.progressStyle();
        progressStyle.overlay(helper.fluid(fluidStack));
        IBorderStyle borderStyle = helper.borderStyle();
        IElement tank = helper.progress((float)fluidStack.getAmount() / (float)capacity, (Component)text, progressStyle, borderStyle);
        return List.of(tank);
    }
}

